//==================================================================================
//
//	title : VSsheep[ effect.cpp ]		Auter : KENSUKE WATANABE
//											Data  : 2016/08/30
//
//----------------------------------------------------------------------------------
//Update : 2016/08/30
//
//==================================================================================
//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include <math.h>
#include "main.h"
#include "manager.h"
#include "effect2DPoly.h"
#include "modeGame.h"
#include "renderer.h"
#include "texManager.h"

const int CEffect2DPoly::MAX_EFFECT = 1024;
int CEffect2DPoly::m_maxEffect = 0;
int CEffect2DPoly::m_cnt = 0;

//-----------------------------------------------------------------------------
// ֐
//-----------------------------------------------------------------------------
void CEffect2DPoly::Init(void)
{
	m_bUse = false;
	m_fRadius = 0.0f;					// a
	m_fRadiusValue = 0.0f;				// aω
	m_fColorAlphaValue = 0.0f;			// l̕ω
	m_nLife = 0;						// 
	m_pos = D3DXVECTOR2(0.0f, 0.0f);	// W
	m_scl = D3DXVECTOR2(0.0f, 0.0f);	// g嗦
	m_rot = D3DXVECTOR2(0.0f, 0.0f);	// ]p
	m_size = D3DXVECTOR2(0.0f, 0.0f);	// TCY
	m_r = 0;
	m_g = 0;
	m_b = 0;
	m_a = 0;
	m_move = D3DXVECTOR2(0.0f, 0.0f);
	m_scl = D3DXVECTOR2(1.0f, 1.0f);
}

//-----------------------------------------------------------------------------
// I
//-----------------------------------------------------------------------------
void CEffect2DPoly::Uninit(void)
{
	ReleaseAll();
}

//-----------------------------------------------------------------------------
// XV֐
//-----------------------------------------------------------------------------
void CEffect2DPoly::UpdateAll(std::vector<CEffect2DPoly> *vecEffect2DPoly)
{
	VERTEX_2D* pVtx;	//_񏑂ݐ̃|C^ϐ

	std::for_each(vecEffect2DPoly->begin(), vecEffect2DPoly->end(), [&](CEffect2DPoly &it)
	{
		if (it.m_bUse)
		{
			//obt@bN
			it.m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);
			//gp̃GtFNg̍XV
			it.m_nLife--;	//炷
			if (it.m_nLife <= 0)
			{//0ȉɂȂ
				it.m_bUse = false;	//gptOIt
			}
			else
			{
				//F̐ݒ
				it.m_a -= it.m_fColorAlphaValue;
				if (it.m_a < 0.0f)
				{//l0.0菬ȂȂ悤
					it.m_a = 0.0f;
				}
			}
			//a̍XVƐݒ
			it.m_fRadius -= it.m_fRadiusValue;
			if (it.m_fRadius < 0.0f)
			{//a0.0菬ȂȂ悤
				it.m_fRadius = 0.0f;
			}

			// W̉Z
			it.m_pos += D3DXVECTOR2(it.m_move.x, it.m_move.y);

			//_|S̃|SWWƔaZoď
			it.SetEffectVertex(pVtx);

			//_obt@AbN
			it.m_pVtxBuffer->Unlock();
		}
	});
}

//-----------------------------------------------------------------------------
// `揈֐
//-----------------------------------------------------------------------------
void CEffect2DPoly::DrawAll(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);				// Cg\It
	pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);		// DESTRGB̌WPɂ
	pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);		// Zobt@

	std::vector<CEffect2DPoly> *vecEffect2DPoly = CManager::GetVecEffect2DPoly();
	std::for_each(vecEffect2DPoly->begin(), vecEffect2DPoly->end(), [&](CEffect2DPoly &it)
	{
		//gĂp[eBN̕`
		if (it.m_bUse)
		{
			// _obt@foCX̃f[^ Xg[ɃoCh
			pDevice->SetStreamSource(0, it.m_pVtxBuffer, 0, sizeof(VERTEX_2D));

			// _tH[}bg̐ݒ
			pDevice->SetFVF(FVF_VERTEX_2D);

			// eNX`̐ݒ
			pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(it.m_strFilePass));

			// |S̕` // |Š`, [hŏ̒_̃CfbNX, |S
			pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON);
		}
	});

	pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);			// Zobt@
	// Cg̕\Lɂ
	pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);

	//_[Xe[g̐ݒ߂
	pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
	pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
}

//-----------------------------------------------------------------------------
// _쐬
//-----------------------------------------------------------------------------
HRESULT CEffect2DPoly::MakeVertexEffect(void)
{
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();
	std::vector<CEffect2DPoly> *vecEffect2DPoly = CManager::GetVecEffect2DPoly();
	std::for_each(vecEffect2DPoly->begin(), vecEffect2DPoly->end(), [&](CEffect2DPoly &it)
	{
		//_obt@쐬
		if (FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,
			D3DUSAGE_WRITEONLY, FVF_VERTEX_2D, D3DPOOL_MANAGED, &it.m_pVtxBuffer, nullptr)))
		{
			assert(!"_̍쐬Ɏs");
		}

		//obt@bN
		VERTEX_2D* pVtx;
		it.m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);
		//WƐFݒ
		pVtx[0].tex = D3DXVECTOR2(0.0f, 0.0f);
		pVtx[1].tex = D3DXVECTOR2(1.0f, 0.0f);
		pVtx[2].tex = D3DXVECTOR2(0.0f, 1.0f);
		pVtx[3].tex = D3DXVECTOR2(1.0f, 1.0f);
		for (int i = 0; i < 4; i++)
		{
			pVtx[i].rhw = 1.0f;
			pVtx[i].pos = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
			pVtx[i].col = D3DCOLOR_RGBA(it.m_r, it.m_g, it.m_b, it.m_a);
		}
		//bN̉
		it.m_pVtxBuffer->Unlock();
	});

	return NOERROR;
}

// 
void CEffect2DPoly::Create(int no, std::vector<CEffect2DPoly> *vecEffect2DPoly, std::string texName)
{
	CEffect2DPoly effPoly;
	effPoly.Init();
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(texName);

	if (vecEffect2DPoly->empty())
	{
		for (int nCnt = 0; nCnt < no; nCnt++)
		{
			effPoly.m_strFilePass = texName;
			CEffect2DPoly::MakeVertexEffect();
			vecEffect2DPoly->push_back(effPoly);
		}
	}
	CEffect2DPoly::m_maxEffect = no;
}

//-----------------------------------------------------------------------------
// GtFNgݒ
//-----------------------------------------------------------------------------
void CEffect2DPoly::SetEffect2DPoly(D3DXVECTOR2 pos, D3DXVECTOR2 rot, D3DXVECTOR2 move, float radius, int &r, int &g, int &b, int &a, int life, std::string texName)
{
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(texName);
	std::vector<CEffect2DPoly> *vecEffect2DPoly = CManager::GetVecEffect2DPoly();
	CEffect2DPoly effPoly;

	for(int nCnt = 0; nCnt < MAX_EFFECT; nCnt++)
	{//gĂȂe
		if(!vecEffect2DPoly->at(nCnt).m_bUse)
		{
			// GtFNgZbg
			vecEffect2DPoly->at(nCnt).m_strFilePass = texName;
			vecEffect2DPoly->at(nCnt).m_pos = pos;
			vecEffect2DPoly->at(nCnt).m_rot = rot;
			vecEffect2DPoly->at(nCnt).m_move = move;
			vecEffect2DPoly->at(nCnt).m_fRadius = radius;
			vecEffect2DPoly->at(nCnt).m_r = r; 
			vecEffect2DPoly->at(nCnt).m_g = g; 
			vecEffect2DPoly->at(nCnt).m_b = b; 
			vecEffect2DPoly->at(nCnt).m_a = a;
			vecEffect2DPoly->at(nCnt).m_nLife = life;

			vecEffect2DPoly->at(nCnt).m_bUse = true;
			vecEffect2DPoly->at(nCnt).m_fRadiusValue = radius * 0.5f / life;	//s܂łɑ傫𔼕ɂȂ悤ɒlݒ
			vecEffect2DPoly->at(nCnt).m_fColorAlphaValue = 1.0f / life;			//s܂łɓɂȂ悤ɒlݒ
			break;
		}
	}
}

//-----------------------------------------------------------------------------
// _Wݒ
//-----------------------------------------------------------------------------
void CEffect2DPoly::SetEffectVertex(VERTEX_2D* pVtx)
{
	//_W̐ݒ
	pVtx[0].pos = D3DXVECTOR3(-m_fRadius + m_pos.x, -m_fRadius + m_pos.y, 0.0f);
	pVtx[1].pos = D3DXVECTOR3(m_fRadius + m_pos.x, -m_fRadius + m_pos.y, 0.0f);
	pVtx[2].pos = D3DXVECTOR3(-m_fRadius + m_pos.x, m_fRadius + m_pos.y, 0.0f);
	pVtx[3].pos = D3DXVECTOR3(m_fRadius + m_pos.x, m_fRadius + m_pos.y, 0.0f);

	int r = m_r;
	int g = m_g;
	int b = m_b;
	int a = m_a;
	//_F̐ݒ
	pVtx[0].col = D3DCOLOR_RGBA(r, g, b, a);
	pVtx[1].col = D3DCOLOR_RGBA(r, g, b, a);
	pVtx[2].col = D3DCOLOR_RGBA(r, g, b, a);
	pVtx[3].col = D3DCOLOR_RGBA(r, g, b, a);
}

void CEffect2DPoly::FlashAll(void)
{
	std::vector<CEffect2DPoly> *vecEffect2DPoly = CManager::GetVecEffect2DPoly();
	for_each(vecEffect2DPoly->begin(),vecEffect2DPoly->end(), [](CEffect2DPoly &it)
	{
		if (it.m_bUse == false)return;
		//obt@bN
		VERTEX_2D* pVtx;
		it.m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);
		//_F̐ݒ
		pVtx[0].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		pVtx[1].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		pVtx[2].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		pVtx[3].col = D3DCOLOR_RGBA(0, 0, 0, 0);
		it.m_pVtxBuffer->Unlock();
		it.m_bUse = false;
	});
}

void CEffect2DPoly::ReleaseAll(void)
{
	std::vector<CEffect2DPoly> *vecEffect2DPoly = CManager::GetVecEffect2DPoly();
	vecEffect2DPoly->erase(remove_if(vecEffect2DPoly->begin(), vecEffect2DPoly->end(), [](CEffect2DPoly &it) 
	{
		// Vtxobt@̉
		if (it.m_pVtxBuffer != nullptr)
		{
			it.m_pVtxBuffer->Release();
			it.m_pVtxBuffer = nullptr;
		}
		return true;
	}), vecEffect2DPoly->end());

	m_maxEffect = 0;
}